#ifndef  __SDKS_FACE_H__
#define  __SDKS_FACE_H__
#include "sdk_def.h"
#include "rj_type.h"

typedef struct rename_t
{
	char  old_name[64];
	char  new_name[64];
}rename_t;

typedef struct rename_info_t
{
	rename_t  name[10];
	int       data_chn;
	int       num;
}rename_info;

//typedef struct jy_face_param_t
//{
//	uint16		 name_len;
//	char		 name[32];//face name 
//	uint16		 id_len;
//	char		 id[32];
//	char		 gender;
//	uint32		 birthday;
//	uint16		 group_len;
//	char         group[32];//face database group
//	uint16		 type_len;
//	char		 type[32];//face type
//	uint32		 s_time;
//	uint32		 e_time;
//}jy_face_param;



typedef struct face_search_param_t
{
	uint16		 chn_num;//channel number
	uint16		 chn_list;//channel list
	uint32		 s_time;//start time of search range
	uint32		 e_time;//end time of search range
	char         search_type;
	char		 similarity;//similarity
	uint16		 id_len;//feature id
	char		 id[32];
	uint16		 name_len;
	char		 name[32];//feature name
	char         gender;//feature gender 
}face_search_param;


typedef struct page_param_t
{
	int			 total_pic_num;//total number of image indexes
	int			 total_page_num;//total number of client paging
	int			 page;//page
}page_param;

typedef struct  group_page_param_t
{
	char	groups[32][64];//client
	int		total_mem_num;
	int		total_page_num;
	int		page;//current page
	int     group_num;
}group_page_param;


SDKS_API int sdks_start_face(unsigned int handle, SDK_FACE_CB face_cb, void *p_obj);
SDKS_API int sdks_stop_face(unsigned int handle);

//Get request on face database
SDKS_API int sdks_face_get_group(unsigned int handle, int type, char** result);
//Add face database
SDKS_API int sdks_face_add_group(unsigned int handle, char *p_db_info);
//Delete face database
SDKS_API int sdks_face_del_group(unsigned int handle, char *p_db_info);
//Rename face database
SDKS_API int sdks_face_rename_group(unsigned int handle, char *p_db_info);

//Get request on face database type
SDKS_API int sdks_face_get_group_type(unsigned int handle, char** result);
//Add face type
SDKS_API int sdks_face_add_group_type(unsigned int handle, char *p_db_info);
//Delete face type
SDKS_API int sdks_face_del_group_type(unsigned int handle, char *p_db_info);

//Add face image to face database
SDKS_API int sdks_add_face_data_to_group(unsigned int handle, char *p_param, char *pic_data, int pic_size); 
//Delete face image data
SDKS_API int sdks_del_face_data(unsigned int handle,char *p_param); 
//Modify face picture
SDKS_API int  sdks_mod_face_data(unsigned int handle, char *p_param, char *pic_data, int pic_size); 
//Query base image
SDKS_API int  sdks_get_face_all_node(unsigned int handle,char *p_param, char **result);
SDKS_API int  sdks_get_face_by_node(unsigned int handle, char *p_info);
//Query face information by face database index
 SDKS_API int  sdks_get_face_info(unsigned int handle, char *p_param, char **p_result);
 //Get the face database index
 SDKS_API int sdks_get_face_lib(unsigned int handle, char *p_param, char **result);
 //Query pictures by face database index
 SDKS_API int sdks_get_face_lib_pic(unsigned int handle, char *p_param, SDK_FACE_CB face_cb);
 //Delete face database
 SDKS_API int sdks_del_face_lib(unsigned int handle, char *p_param);

//Face query on real-time library conditions
 SDKS_API int sdks_dev_get_database_index(unsigned int handle, int chn, char *p_buf, int size, char *param, int *p_task, char **p_result);
 SDKS_API int sdks_dev_get_database_info(unsigned int handle, char *param);
#endif